 -- VERSAO 0013 - DATA 2021-05-06
IF EXISTS (
		SELECT *
		FROM SYS.procedures
		WHERE NAME = 'P_SNGPC_SAIDA_AUTOMATICA'
		)
BEGIN
	DROP PROCEDURE P_SNGPC_SAIDA_AUTOMATICA;
END;
GO

/*
=======================================================================================
'Job.................: É executada pela procedure P_PDV_VD_IT_REC_PELO_SNGPC
'Função..............: 
'Objetivo............: Vinculo da venda com receita  
'Tabelas.............: EST_SNGPC_PEND_SAIDA_VENDAS_AUDIT
'Dt Modificação......: 20/05/2021
'Modificação.........: Wilson realizando ajustes gerais relacionado ao projeto SNGPC
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/ 
CREATE PROCEDURE P_SNGPC_SAIDA_AUTOMATICA (@CD_EMP INT = 1 )
AS
BEGIN
	SET NOCOUNT ON;

	CREATE TABLE #INSERT_VENDAS (
		CD_EMP INT
		,CD_FILIAL INT
		,CD_PROD INT
		,CD_VD INT
		,CD_LOTE INT
		,CD_IT INT
		,DT_VD DATETIME
		,QTDE_LANCAMENTO INT
		,CD_RECEITA INT
		);

	CREATE TABLE #VENDAS_ERROS (
		CD_EMP INT
		,CD_FILIAL INT
		,CD_VD INT
		,CD_IT INT
		,CD_LOTE INT
		,CD_LOTE_GESTAO INT
		);
    CREATE TABLE #INSERT_SAIDAS_TRANSF (
		CD_EMP INT
		,CD_FILIAL INT
		,CD_PROD INT
		,CD_NF INT
		,CD_LOTE INT
		,CD_IT INT
		,DT_EMISS_NF DATETIME
		,QTDE_LANCAMENTO INT
	
		);
    
    CREATE TABLE #TRANSF_ERROS (
		CD_EMP INT
		,CD_FILIAL INT
		,CD_NF INT
		,CD_IT INT
		,CD_LOTE INT
		,CD_LOTE_GESTAO INT
		);    

	DECLARE @ARES TABLE (CD_RECEITA INT);
	DECLARE @CD_FILIAL INT;
    DECLARE @CD_NF INT;
    DECLARE @NR_NF INT;
	DECLARE @NR_RECEITA INT;
	DECLARE @LANCADO INT
	DECLARE @OLD_FILIAL INT;
	DECLARE @DS_ERRO VARCHAR(255);
	DECLARE @VAL_INSERT INT;
	DECLARE @CD_PROD INT;
	DECLARE @CD_RECEITA INT;
	DECLARE @CD_VD INT;
	DECLARE @CD_LOTE INT;
	DECLARE @DT_VD DATETIME;
	DECLARE @CD_IT INT;
	DECLARE @NR_LOTE VARCHAR(60);
	DECLARE @QTDE_PROD INT;
    DECLARE @QTDE_LANCAMENTO INT;
	DECLARE @DT_VALID DATETIME;
	DECLARE @REGISTRO_MS VARCHAR(60);
	DECLARE @NR_ECF INT;
	DECLARE @QT_LOTE_ORC INT;
	DECLARE @SALDO_SNGPC INT;
	DECLARE @CD_LOTE_GESTAO INT;
	DECLARE @DATA_LIMITE DATETIME;
	DECLARE @SAIDA_AUTOMATICA INT;
	DECLARE @NR_ORC INT;
	DECLARE @NR_DOC VARCHAR(30);
	DECLARE @DT_RECEITA DATETIME;
	DECLARE @CD_TP_RECEITA INT;
	DECLARE @CD_TP_DOC INT;
	DECLARE @CD_ORG_EXP INT;
	DECLARE @UF_DOC VARCHAR(2);
	DECLARE @NM_PACIENTE VARCHAR(255);
	DECLARE @CID VARCHAR(10);
    DECLARE @ErrorMessage VARCHAR(MAX);
	DECLARE @SEXO INT;
	DECLARE @IDADE INT;
	DECLARE @UND_IDADE INT;
	DECLARE @CONSELHO VARCHAR(20);
	DECLARE @CD_COMPRADOR INT;
	DECLARE @NR_DOC_CLI VARCHAR(30);
	DECLARE @COMPRADOR_NOME VARCHAR(60);
	DECLARE @COMPRADOR_DOC_NUMERO VARCHAR(50);
	DECLARE @CD_CLI INT;
	DECLARE @TIPO_CLIENTE VARCHAR(10);
	DECLARE @COMPRADOR_DOC_TIPO VARCHAR(50);
    DECLARE @QT_LOTE_TRANSF  INT;
    DECLARE @DT_EMISS_NF DATETIME;

    PRINT 'INICIANDO'; 
	DECLARE PENDENCIAS_CUPOM CURSOR FAST_FORWARD
	FOR
	WITH 
		TBVENDAS
	AS (
		SELECT 
			V.CD_EMP
			,V.CD_FILIAL
			,V.CD_VD
			,V.CD_CX
			,V.NR_ECF
			,V.NR_ORC
			,A.DT_VD
			,A.CD_PROD
			,A.CD_IT
			,SUM(COALESCE(A.QT_IT - CCL.QT_CANCEL, A.QT_IT)) AS QT_IT
			,MAX(COALESCE(L.LANCADO, 0)) AS LANCADO
		FROM 
			PDV_VD(NOLOCK) V
			INNER JOIN PDV_VD_IT(NOLOCK) A ON 
				V.CD_EMP = A.CD_EMP
				AND V.CD_FILIAL = A.CD_FILIAL
				AND V.CD_VD = A.CD_VD
				AND V.DT_VD = A.DT_VD
			LEFT JOIN (
				SELECT 
					D.CD_EMP
					,D.CD_FILIAL
					,D.CD_VD
					,SUM(SAI.QT_LOTE) LANCADO
				FROM 
					EST_SNGPC_SAIDA(NOLOCK) AS SAI
					INNER JOIN PDV_VD_IT_EST_SNGPC_SAIDA(NOLOCK) D ON 
						D.CD_SAI_SNGPC = SAI.CD_SAI_SNGPC
				GROUP BY 
					D.CD_EMP
					,D.CD_FILIAL
					,D.CD_VD) L ON 
				V.CD_EMP = L.CD_EMP
				AND V.CD_FILIAL = L.CD_FILIAL
				AND V.CD_VD = L.CD_VD
	
			INNER JOIN EST_PROD(NOLOCK) P ON A.CD_PROD = P.CD_PROD
				AND A.CD_EMP = P.CD_EMP
		
			LEFT JOIN PDV_VD_IT_EST_SNGPC_PENDENTE_CANCELADO(NOLOCK) AS CCL ON 
				A.CD_EMP = CCL.CD_EMP
				AND A.CD_FILIAL = CCL.CD_FILIAL
				AND A.CD_VD = CCL.CD_VD
				AND A.CD_IT = CCL.CD_IT
			LEFT JOIN EST_ORC(NOLOCK) AS ORC ON 
				V.CD_EMP = ORC.CD_EMP
				AND V.CD_FILIAL = ORC.CD_FILIAL
				AND V.NR_ORC = ORC.CD_ORC
			LEFT JOIN PDV_VD_IT_LOTE(NOLOCK) LT ON 
				LT.CD_EMP = A.CD_EMP
				AND LT.CD_FILIAL = A.CD_FILIAL
				AND LT.CD_VD = A.CD_VD
				AND LT.CD_IT = A.CD_IT
			LEFT JOIN EST_PROD_CPL_LOTE LG 
				ON LG.CD_EMP = LT.CD_EMP
				AND LG.CD_FILIAL = LT.CD_FILIAL
				AND LG.CD_PROD = A.CD_PROD
				AND LG.CD_LOTE = LT.CD_LOTE
			LEFT JOIN EST_PROD_EST_SNGPC_LOTE PL ON 
				PL.NR_LOTE = LG.NR_LOTE
				AND PL.CD_PROD = LG.CD_PROD
			LEFT JOIN EST_PROD_EST_SNGPC_LOTE_CPL PLI ON 
				PLI.CD_EMP = V.CD_EMP
				AND PLI.CD_FILIAL = V.CD_FILIAL
				AND PLI.CD_LOTE = LG.CD_LOTE
            INNER JOIN PRC_FILIAL_CONFIG VALFILIAL  ON
               VALFILIAL.CD_FILIAL   = V.CD_FILIAL  
               AND VALFILIAL.CD_CHAVE = 'SNGPC_Confronta_Quantidade_Lote_Venda'
               AND VALFILIAL.VALOR  =1
		WHERE 
			P.CONTROLE_SNGPC = 1
			AND A.CD_EMP = @CD_EMP			
			AND A.ST_IT = 1 --ITENS ATIVOS                                
			AND V.ST_VD = 0 --VENDAS ATIVAS                               
			AND V.DT_VD > DATEADD(MONTH, - 1, GETDATE()) 
		GROUP BY 
			V.CD_EMP
			,V.CD_FILIAL
			,V.CD_VD
			,V.CD_CX
			,V.NR_ECF
			,ORC.NR_ORC_LOJA
			,V.NR_ORC
			,A.DT_VD
			,A.CD_PROD
			,A.CD_IT
			,V.VLR_LIQ_VD
			,V.NR_PED_TELEVD)
	SELECT 
		A.CD_FILIAL
		,A.CD_VD
		,A.NR_ECF
		,A.NR_ORC
		,A.DT_VD
		,A.CD_PROD
		,A.QT_IT
		,A.LANCADO
		,LG.NR_LOTE
		,LF.QT_LOTE
		,LT.QTDE_PROD AS QTDE_LOTE
		,A.CD_IT
		,LS.CD_LOTE
		,LT.CD_LOTE
	FROM 
		TBVENDAS A
		LEFT JOIN PDV_VD_IT_LOTE (NOLOCK) LT ON 
			LT.CD_EMP = A.CD_EMP
			AND LT.CD_FILIAL = A.CD_FILIAL
			AND LT.CD_VD = A.CD_VD
			AND LT.CD_IT = A.CD_IT
		LEFT JOIN EST_PROD_CPL_LOTE LG ON 
			LG.CD_EMP = A.CD_EMP
			AND LG.CD_FILIAL = A.CD_FILIAL
			AND LG.CD_LOTE = LT.CD_LOTE
		LEFT JOIN EST_PROD_EST_SNGPC_LOTE LS ON 
			LS.CD_PROD = LG.CD_PROD
			AND LS.NR_LOTE = LG.NR_LOTE
		LEFT JOIN EST_PROD_EST_SNGPC_LOTE_CPL LF ON
             LF.CD_LOTE = LS.CD_LOTE
			AND LF.CD_FILIAL = A.CD_FILIAL
	WHERE 
		COALESCE(LANCADO, 0) = 0 

	OPEN PENDENCIAS_CUPOM;

	FETCH NEXT
	FROM PENDENCIAS_CUPOM
	INTO
        @CD_FILIAL
		,@CD_VD
		,@NR_ECF
		,@NR_ORC
		,@DT_VD
		,@CD_PROD
		,@QTDE_PROD
		,@LANCADO
		,@NR_LOTE
		,@SALDO_SNGPC
		,@QT_LOTE_ORC
		,@CD_IT
		,@CD_LOTE
		,@CD_LOTE_GESTAO

	WHILE @@FETCH_STATUS = 0
	BEGIN
		PRINT 'TRATANDO VENDA FILIAL - ' + CAST(@CD_FILIAL AS VARCHAR(30)) + '  VENDA ' + CAST(@CD_VD AS VARCHAR(30)) + ' ORCAMENTO: ' + CAST(@NR_ORC AS VARCHAR(30));
        SET @DS_ERRO ='';  
		SET @CD_RECEITA = (
			SELECT TOP 
				1 R.CD_RECEITA
			FROM 
				EST_SNGPC_RECEITA R
				INNER JOIN EST_SNGPC_RECEITA_IT I ON 
					I.CD_FILIAL = R.CD_FILIAL
					AND I.CD_RECEITA = R.CD_RECEITA
				WHERE 
					I.CD_VD = @CD_VD
					AND I.CD_FILIAL = @CD_FILIAL
					AND I.CD_IT = @CD_IT)

		
		IF @CD_RECEITA IS NULL
		BEGIN
			PRINT 'IMPORTANDO RECEITA FILIAL - ' + CAST(@CD_FILIAL AS VARCHAR(30)) + '  VENDA ' + CAST(@CD_VD AS VARCHAR(30)) + ' ORCAMENTO: ' + CAST(@NR_ORC AS VARCHAR(30));

			
			SELECT TOP 1 
						@COMPRADOR_NOME=NM_COMPRADOR,
						@COMPRADOR_DOC_NUMERO=NR_DOC_CLI
					FROM EST_ORC_GLB_MEDICO
					WHERE CD_EMP = 1
						AND CD_FILIAL = @CD_FILIAL
						AND NR_ORC = @NR_ORC
						AND CD_PROD = @CD_PROD ;

			SET @COMPRADOR_DOC_TIPO = (
					SELECT TOP 1 TIPO_DOCUMENTO
					FROM EST_ORC_GLB_MEDICO
					WHERE CD_EMP = 1
						AND CD_FILIAL = @CD_FILIAL
						AND NR_ORC = @NR_ORC
						AND CD_PROD = @CD_PROD 
					);

		
			IF (@COMPRADOR_NOME <> '')
			BEGIN
				SET @CD_CLI = NULL;
				SET @CD_CLI = (
						SELECT TOP 1 CD_CLI I
						FROM RC_CLI(NOLOCK)
						WHERE NM_FANT = @COMPRADOR_NOME
						)

				IF (@CD_CLI IS NOT NULL)
					SET @TIPO_CLIENTE = 'G'
			END

			IF (
					(CAST(@COMPRADOR_DOC_NUMERO AS VARCHAR(max)) <> '0')
					AND (CAST(@COMPRADOR_DOC_NUMERO AS VARCHAR(max)) <> '')
					AND (@CD_CLI IS NULL)
					)
			BEGIN
				SET @CD_CLI = NULL;
				SET @CD_CLI = (
						SELECT TOP 1 cd_cli I
						FROM rc_cli_sngpc(NOLOCK)
						WHERE documento = CAST(@COMPRADOR_DOC_NUMERO AS VARCHAR(max))
							AND cd_filial = @CD_FILIAL
						);
			END

			IF (
					@CD_CLI IS NULL
					AND @COMPRADOR_NOME <> ''
					)
			BEGIN
				SET @CD_CLI = (
						SELECT TOP 1 cd_cli I
						FROM rc_cli_sngpc(NOLOCK)
						WHERE rz_cli = @COMPRADOR_NOME
							AND cd_filial = @CD_FILIAL
						);
			END

			IF (
					@CD_CLI IS NULL
					AND (CAST(@COMPRADOR_DOC_NUMERO AS VARCHAR(max)) <> '0')
					AND (CAST(@COMPRADOR_DOC_NUMERO AS VARCHAR(max)) <> '')
					)
			BEGIN
				SET @CD_CLI = (
						SELECT COALESCE(MAX(cd_cli) + 1, 1)
						FROM rc_cli_sngpc(NOLOCK)
						WHERE cd_filial = @CD_FILIAL
							AND cd_emp = @CD_EMP
						)

				SET @TIPO_CLIENTE ='S'

				INSERT INTO rc_cli_sngpc (
					cd_emp
					,cd_filial
					,cd_cli
					,documento
					,rz_cli
					,nm_fant
					,tipo_doc
					,dt_cad
					,cd_usu
					)
				VALUES (
					@CD_EMP
					,@CD_FILIAL
					,@CD_CLI
					,@COMPRADOR_DOC_NUMERO
					,@COMPRADOR_NOME
					,@COMPRADOR_NOME
					,@COMPRADOR_DOC_TIPO
					,GETDATE()
					,1
					)
			END

			DELETE
			FROM @ARES;		
			INSERT INTO EST_SNGPC_RECEITA (
				CD_EMP
				,CD_FILIAL
				,DT_RECEITA
				,CD_TP_RECEITA
				,NR_RECEITA
				,CD_CTR
				,CD_CLI
				,NR_DOC_CLI
				,CD_TP_DOC
				,CD_ORG_EXP
				,UF_DOC
				,NM_PACIENTE
				,DT_ULT_ALT
				,CD_USU
				,CLI_SNGPC_GESTAO
				,CID
				,SEXO
				,IDADE
				,UND_IDADE
				,USO_CONTINUO
				,CD_VD
				,CD_RECEITA_PDV
				,SUBSIDIO
				)
			OUTPUT INSERTED.CD_RECEITA
			INTO @ARES
			SELECT CD_EMP
				,CD_FILIAL
				,DT_RECEITA
				,RECEITA_TIPO
				,NR_RECEITA
				,CD_MEDICO_REC
				,@CD_CLI
				,NR_DOC_CLI
				,TIPO_DOCUMENTO
				,TP_DOC_EXP
				,UF
				,NM_PACIENTE
				,GETDATE()
				,1
				,@TIPO_CLIENTE
				,CID
				,0
				,IDADE
				,TP_IDADE
				,0
				,@CD_VD
				,@CD_VD
				,0
			FROM 
				EST_ORC_GLB_MEDICO CRM
			WHERE 
				CRM.CD_FILIAL = @CD_FILIAL
				AND CRM.NR_ORC = @NR_ORC
				AND CRM.CD_PROD = @CD_PROD

		
			SET @CD_RECEITA = (
					SELECT CD_RECEITA
					FROM @ARES
					);

			IF COALESCE(@CD_RECEITA, 0) > 0
			BEGIN
				BEGIN TRY
                    INSERT INTO EST_SNGPC_RECEITA_IT (
                        CD_EMP
                        ,CD_FILIAL
                        ,CD_VD
                        ,CD_IT
                        ,CD_RECEITA
                        )
                    VALUES (
                        1
                        ,@CD_FILIAL
                        ,@CD_VD
                        ,@CD_IT
                        ,@CD_RECEITA
                     );
                END TRY
                BEGIN CATCH 
                  SELECT 
                       @ErrorMessage = ERROR_MESSAGE()  
                  SET @DS_ERRO = 'FILIAL - ' + CAST(COALESCE( @CD_FILIAL,0) AS VARCHAR(30))
                      + '  VENDA ' + CAST(COALESCE( @CD_VD,0) AS VARCHAR(30))
                      + ' RECEITA DO ORCAMENTO: ' + CAST(COALESCE( @NR_ORC,0) AS VARCHAR(30)) 
                      + ' CODIGO : ' + CAST(@CD_RECEITA AS VARCHAR(30)) 
                      + '  FALHA AO INSERIR '+ COALESCE( @ErrorMessage ,'FALHA AO INSERIR NA TABELA EST_SNGPC_RECEITA_IT') ;
                END CATCH  
			
				BEGIN TRY
                    DELETE 
                        A
                    FROM 
                        EST_SNGPC_RECEITA AS A
                        LEFT JOIN EST_SNGPC_RECEITA_IT I ON I.CD_EMP = A.CD_EMP
                            AND I.CD_FILIAL = A.CD_FILIAL
                            AND I.CD_VD = A.CD_VD
                    WHERE 
                        A.CD_VD = @CD_VD
                        AND A.CD_FILIAL = @CD_FILIAL
                        AND I.CD_VD IS NULL
                END TRY
                BEGIN CATCH 
                END CATCH          
			END;
		END;

		SET @VAL_INSERT = 1;

		IF @CD_RECEITA IS NULL
		BEGIN
			SET @DS_ERRO = 'FILIAL - ' + CAST(COALESCE( @CD_FILIAL,0) AS VARCHAR(30))
             + '  VENDA ' + CAST(COALESCE( @CD_VD,0) AS VARCHAR(30))
              + ' RECEITA DO ORCAMENTO: ' + CAST(COALESCE( @NR_ORC,0) AS VARCHAR(30)) 
            + '  NÃO ENCONTRADA';
			SET @VAL_INSERT = 0;

			PRINT @DS_ERRO;
		END
		ELSE
		BEGIN

			SET @CD_TP_RECEITA = (SELECT TOP 1 CD_TP_RECEITA FROM EST_SNGPC_RECEITA WHERE CD_RECEITA = @CD_RECEITA)

			
			PRINT 'RECEITA ' + CAST(@CD_RECEITA AS VARCHAR(30)) + + '  ENCONTRADA VALIDANDO DADOS...'

			IF @NR_DOC = ''
				SET @DS_ERRO = 'médico prescritor da receita NÃO informado!';

			IF @CD_TP_RECEITA IS NULL
				SET @DS_ERRO = 'tipo da receita NÃO informado!';

			IF @CONSELHO <> 'CRMV' ---NAO VALIDAR COMPRADOR OU PACIENTE PARA O VETERINARIO
			BEGIN
				IF @CD_TP_RECEITA = 0 
				BEGIN
					IF @CD_COMPRADOR IS NULL
						SET @DS_ERRO = 'Receita de controlados exige comprador !';
				END;

				IF @CD_TP_RECEITA = 1 
				BEGIN
					IF @CD_COMPRADOR IS NULL
						SET @DS_ERRO = 'Receita B exige comprador !';
				END;

				IF @CD_TP_RECEITA = 2 
				BEGIN
					IF @CD_COMPRADOR IS NULL
						SET @DS_ERRO = 'Receita de retinoides exige comprador !';
				END;

				IF @CD_TP_RECEITA <> 4 
				BEGIN
					IF COALESCE(@NR_DOC_CLI, '') = ''
						SET @DS_ERRO = 'Numero do documento  do comprador deve ser informado !';

					IF COALESCE(@CD_TP_DOC, - 1) < 0
						SET @DS_ERRO = 'Tipo de documento do comprador deve ser informado !';

					IF COALESCE(@CD_ORG_EXP, - 1) < 0
						SET @DS_ERRO = 'Orgão expedidor do documento do comprador deve ser informado !';

					IF COALESCE(@UF_DOC, '') = ''
						SET @DS_ERRO = 'Uf  do documento do comprador deve ser informado !';
				END;

				IF (@CD_TP_RECEITA = 3) 
				BEGIN
					IF @CD_COMPRADOR IS NULL
						SET @DS_ERRO = 'Receita Amarela  exige comprador !';
				END;

				IF (@CD_TP_RECEITA = 4) 
				BEGIN
					IF COALESCE(@NM_PACIENTE, '') = ''
						SET @DS_ERRO = 'Receita de antibioticos exige paciente !';

					IF COALESCE(@IDADE, 0) = 0
						SET @DS_ERRO = 'idade do paciente deve ser informada!';

					IF COALESCE(@UND_IDADE, - 1) < 0
						SET @DS_ERRO = 'Tipo de idade do paciente deve ser informada !';

					IF COALESCE(@SEXO, - 1) < 0
						SET @DS_ERRO = 'Sexo do paciente deve ser imformado!';
				END;
			END;

			IF @OLD_FILIAL <> @CD_FILIAL
			BEGIN
				SET @DATA_LIMITE = (
						SELECT COALESCE(MAX(DT_FINAL), '1900-01-01')
						FROM EST_SNGPC_RELATORIOS_ANVISA(NOLOCK)
						WHERE CD_EMP = @CD_EMP
							AND CD_FILIAL = @CD_FILIAL
							AND ACEITO = 1
						);
				SET @SAIDA_AUTOMATICA = (
						SELECT VALOR
						FROM PRC_FILIAL_CONFIG(NOLOCK)
						WHERE CD_FILIAL = @CD_FILIAL
							AND CD_CHAVE = 'Confronta_Quantidade_Lote_SNGPC_Venda'
						)
			END;

			IF @QTDE_PROD IS NULL
			BEGIN
				IF @NR_LOTE IS NULL OR @CD_LOTE IS NULL
					SET @DS_ERRO = 'Lote NAO informado na tabela  PDV_VD_IT_LOTE, verificar consolidação'
				ELSE
					SET @DS_ERRO = 'Lote : ' + COALESCE(@NR_LOTE, '-') + ' NAO encontrado  no cadastro do sngpc para a filial informada'

				SET @VAL_INSERT = 0;
			END;

			IF @QT_LOTE_ORC IS NULL 
			BEGIN
				SET @DS_ERRO = 'Lote NAO informado na tabela  PDV_VD_IT_LOTE, verificar consolidação'
				SET @VAL_INSERT = 0;
			END

			IF COALESCE( @QT_LOTE_ORC,0) > COALESCE( @SALDO_SNGPC,0)
			BEGIN
				SET @DS_ERRO = @DS_ERRO + ' Quantidade de lote insuficiente SNGPC : ' + cast(coalesce(@SALDO_SNGPC, 0) AS VARCHAR(30))
				SET @VAL_INSERT = 0;
			END;

			IF @DT_VD < @DATA_LIMITE
			BEGIN
				SET @DS_ERRO = @DS_ERRO + 'Data da venda esta em um  periodo ja enviado para anvisa'
				SET @VAL_INSERT = 0;
			END;
		END;


		IF LEN(@DS_ERRO) > 1
			SET @VAL_INSERT = 0

		IF @VAL_INSERT = 1
		BEGIN
			INSERT INTO #INSERT_VENDAS (
				CD_EMP
				,CD_FILIAL
				,CD_PROD
				,CD_VD
				,CD_LOTE
				,CD_IT
				,DT_VD
				,QTDE_LANCAMENTO
				,CD_RECEITA
				)
			VALUES (
				@CD_EMP
				,@CD_FILIAL
				,@CD_PROD
				,@CD_VD
				,@CD_LOTE
				,@CD_IT
				,@DT_VD
				,@QT_LOTE_ORC
				,@CD_RECEITA
				)
				
		END
		ELSE
		BEGIN
			PRINT 'INSERINDO ERRO: ' + CAST(COALESCE( @CD_FILIAL,0) AS VARCHAR(30))
             + '  CUPOM ' + CAST(COALESCE( @CD_VD,0) AS VARCHAR(30))
             + ' PRODUTO : ' + CAST(COALESCE( @CD_PROD,0) AS VARCHAR(30)) 
             + ' ' + COALESCE( @DS_ERRO,'ERRO DESCONHECIDO');

			INSERT INTO #VENDAS_ERROS (
				CD_EMP
				,CD_FILIAL
				,CD_VD
				,CD_IT
				,CD_LOTE
				,CD_LOTE_GESTAO
				)
			VALUES (
				@CD_EMP
				,@CD_FILIAL
				,@CD_VD
				,@CD_IT
				,@CD_LOTE
				,@CD_LOTE_GESTAO
				);

			INSERT INTO EST_SNGPC_PEND_SAIDA_VENDAS_AUDIT (
				CD_EMP
				,CD_FILIAL
				,CD_PROD
				,NR_LOTE
				,CD_IT
				,CD_VD
				,DT_CAD
				,DS_ERRO
				)
			VALUES (
				@CD_EMP
				,@CD_FILIAL
				,@CD_PROD
				,@NR_LOTE
				,@CD_IT
				,@CD_VD
				,GETDATE()
				,COALESCE(@DS_ERRO,'ERRO-99 DESCONHECIDO')
				)
		END

		SET @OLD_FILIAL = @CD_FILIAL;

		FETCH NEXT
		FROM PENDENCIAS_CUPOM
		INTO @CD_FILIAL
			,@CD_VD
			,@NR_ECF
			,@NR_ORC
			,@DT_VD
			,@CD_PROD
			,@QTDE_PROD
			,@LANCADO
			,@NR_LOTE
			,@SALDO_SNGPC
			,@QT_LOTE_ORC
			,@CD_IT
			,@CD_LOTE
			,@CD_LOTE_GESTAO
	END;
	CLOSE PENDENCIAS_CUPOM;
	DEALLOCATE PENDENCIAS_CUPOM;
	DECLARE PERSITIR_VENDAS CURSOR FAST_FORWARD
	FOR
	SELECT 
		*
	FROM 
		#INSERT_VENDAS
	WHERE 
		NOT EXISTS (
			SELECT 
				CD_VD
			FROM 
				#VENDAS_ERROS
			WHERE 
				#VENDAS_ERROS.CD_EMP = #INSERT_VENDAS.CD_EMP
				AND #VENDAS_ERROS.CD_FILIAL = #INSERT_VENDAS.CD_FILIAL
				AND #VENDAS_ERROS.CD_VD = #INSERT_VENDAS.CD_VD
			)

	OPEN PERSITIR_VENDAS;

	FETCH NEXT
	FROM PERSITIR_VENDAS
	INTO @CD_EMP
		,@CD_FILIAL
		,@CD_PROD
		,@CD_VD
		,@CD_LOTE
		,@CD_IT
		,@DT_VD
		,@QTDE_LANCAMENTO
		,@CD_RECEITA

	WHILE @@FETCH_STATUS = 0
	BEGIN
		BEGIN TRY
		  EXEC P_EST_SNGPC_SAIDA_VENDA_INCLUIR 
			@CD_EMP
			,@CD_FILIAL
			,@CD_LOTE
			,@DT_VD
			,@QTDE_LANCAMENTO
			,@QTDE_LANCAMENTO
			,1
			,@CD_VD
			,@CD_IT
			,@CD_RECEITA
			,0
			,'AUTO_1.2';

	     	PRINT 'INSERINDO VENDA CUPOM: ' + CAST(@CD_FILIAL AS VARCHAR(30)) + '  CUPOM ' + CAST(@CD_VD AS VARCHAR(30)) + ' PRODUTO : ' + CAST(@CD_PROD AS VARCHAR(30)) + ' LOTE ' + CAST(@CD_LOTE AS VARCHAR(30));
		END TRY
		BEGIN CATCH 
          SELECT 
              @ErrorMessage = ERROR_MESSAGE()         		 
		  SET  @DS_ERRO ='ERRO P_EST_SNGPC_SAIDA_VENDA_INCLUIR  ' + COALESCE( @ErrorMessage ,'ERRO DESCONHECIDO') ;
		  INSERT INTO EST_SNGPC_PEND_SAIDA_VENDAS_AUDIT (
				CD_EMP
				,CD_FILIAL
				,CD_PROD
				,NR_LOTE
				,CD_IT
				,CD_VD
				,DT_CAD
				,DS_ERRO
				)
			VALUES (
				@CD_EMP
				,@CD_FILIAL
				,@CD_PROD
				,@NR_LOTE
				,@CD_IT
				,@CD_VD
				,GETDATE()
				,@DS_ERRO
				)
		END CATCH  

		FETCH NEXT
		FROM PERSITIR_VENDAS
		INTO @CD_EMP
			,@CD_FILIAL
			,@CD_PROD
			,@CD_VD
			,@CD_LOTE
			,@CD_IT
			,@DT_VD
			,@QTDE_PROD
			,@CD_RECEITA
	END;

	CLOSE PERSITIR_VENDAS;
	DEALLOCATE PERSITIR_VENDAS;
    PRINT 'ANALISANDO TRANSFERENCIAS';
    --------------------------------------------------------------------------
    -------PROCEDIMENTO PARA TRANSFERENCIAS DE SAIDA ENTRE FILIAS------------
    ---------------------------------------------------------------------------
    DECLARE  PENDENCIAS_SAIDAS_TRANSF  CURSOR FAST_FORWARD FOR    
      SELECT 
        top 10  
         NF.CD_FILIAL
        , NF.CD_NF
        , NF.DT_EMI_NF
        , NF.NF_NF	     
        , SAI.CD_IT
        , SAI.CD_PROD
        , NFI.QT_IT 
        , LG.NR_LOTE
        , LF.QT_LOTE  --SALDO DO LOTE NA FILIAL
        , LT.QTDE_PROD
        , LS.CD_LOTE
        , LT.CD_LOTE        	
    FROM
    EST_NF_SAI_IT_EST_SNGPC_PENDENTE AS SAI
    INNER JOIN EST_NF_SAI AS NF ON
        SAI.CD_EMP          = NF.CD_EMP
        AND SAI.CD_FILIAL   = NF.CD_FILIAL
        AND SAI.CD_NF       = NF.CD_NF
    INNER JOIN EST_NF_SAI_IT AS NFI ON
        SAI.CD_EMP          = NFI.CD_EMP
        AND SAI.CD_FILIAL   = NFI.CD_FILIAL
        AND SAI.CD_NF       = NFI.CD_NF 
        AND SAI.CD_IT       = NFI.CD_IT
        AND SAI.CD_PROD     = NFI.CD_PROD    
                 
    INNER JOIN GLB_MOV_OP AS TRANSF ON
        TRANSF.CD_MOV_OP	= NF.CD_NT_MOV
        AND TRANSF.TP_MOV	= 10
        AND TRANSF.TP_MOV_OP_TRANSA = 1
    INNER JOIN PRC_FILIAL AS FLL ON
        NF.CD_FILIAL         = FLL.CD_FILIAL           
             
    LEFT JOIN EST_NF_SAI_IT_EST_PROD_CPL_LOTE (NOLOCK) LT ON --TABELA DE LOTES DA NOTA DE SAIDA
       LT.CD_EMP = NF.CD_EMP
       AND LT.CD_FILIAL = NF.CD_FILIAL
       AND LT.CD_NF = NF.CD_NF
       AND LT.CD_IT = NFI.CD_IT
    LEFT JOIN EST_PROD_CPL_LOTE LG ON 
        LG.CD_EMP = NF.CD_EMP
        AND LG.CD_FILIAL = NF.CD_FILIAL
        AND LG.CD_LOTE = LT.CD_LOTE
    LEFT JOIN EST_PROD_EST_SNGPC_LOTE LS ON 
        LS.CD_PROD = LG.CD_PROD
        AND LS.NR_LOTE = LG.NR_LOTE
    LEFT JOIN EST_PROD_EST_SNGPC_LOTE_CPL LF ON
         LF.CD_LOTE = LS.CD_LOTE
        AND LF.CD_FILIAL = NF.CD_FILIAL
   
   INNER JOIN PRC_FILIAL_CONFIG VALFILIAL  ON
       VALFILIAL.CD_FILIAL   =NF.CD_FILIAL  
       AND VALFILIAL.CD_CHAVE = 'SNGPC_Confronta_Quantidade_Lote_Venda'
       AND VALFILIAL.VALOR  =1 
        
    WHERE
        SAI.CD_EMP = @CD_EMP     
      
    PRINT 'BUSCANDO TRANSFERENCIAS';     
    OPEN PENDENCIAS_SAIDAS_TRANSF;
    SET @OLD_FILIAL =0;
	FETCH NEXT
    
	FROM PENDENCIAS_SAIDAS_TRANSF
	INTO  
         @CD_FILIAL
		,@CD_NF
		,@DT_EMISS_NF
		,@NR_NF		
		,@CD_IT
        ,@CD_PROD
		,@QTDE_PROD		
		,@NR_LOTE
		,@SALDO_SNGPC
        ,@QT_LOTE_TRANSF		
		,@CD_LOTE
		,@CD_LOTE_GESTAO

	WHILE @@FETCH_STATUS = 0
	BEGIN
       SET @VAL_INSERT = 1;
       SET @DS_ERRO ='';
       PRINT 'TRATANDO TRANSFERENCIA FILIAL - ' + CAST(@CD_FILIAL AS VARCHAR(30)) + '  NF ' + CAST(@NR_NF	 AS VARCHAR(30));		
        --VALIDAR DATA DE LANÇAMENTO
        IF @OLD_FILIAL <> @CD_FILIAL
        BEGIN
            SET @DATA_LIMITE = (
                    SELECT COALESCE(MAX(DT_FINAL), '1900-01-01')
                    FROM EST_SNGPC_RELATORIOS_ANVISA(NOLOCK)
                    WHERE CD_EMP = @CD_EMP
                        AND CD_FILIAL = @CD_FILIAL
                        AND ACEITO = 1
                    );
            SET @SAIDA_AUTOMATICA = (
                    SELECT VALOR
                    FROM PRC_FILIAL_CONFIG(NOLOCK)
                    WHERE CD_FILIAL = @CD_FILIAL
                        AND CD_CHAVE = 'Confronta_Quantidade_Lote_SNGPC_Venda'
                    )
        END;
        IF @QT_LOTE_TRANSF IS NULL
        BEGIN        
          SET @DS_ERRO = 'Lote NAO informado na tabela EST_NF_SAI_IT_EST_PROD_CPL_LOTE,verificar lançamento da nota de saida'
          SET @VAL_INSERT = 0;
        END;
         IF  @CD_LOTE IS NULL 
        BEGIN
          SET @DS_ERRO = 'Lote '+ cast(coalesce(@NR_LOTE, ' ') AS VARCHAR(60)) +' NAO cadastrado NAO pode ser asociado a nehum lote no sngpc pela numeracao '
          SET @VAL_INSERT = 0;
        END

        IF  @SALDO_SNGPC IS NULL 
        BEGIN
          SET @DS_ERRO = 'Lote '+ cast(coalesce(@NR_LOTE, ' ') AS VARCHAR(60)) +' NAO cadastrado no SNGPC nesta filial '
          SET @VAL_INSERT = 0;
        END
        IF COALESCE(  @QT_LOTE_TRANSF,0) > COALESCE( @SALDO_SNGPC,0)
        BEGIN
          SET @DS_ERRO = @DS_ERRO + ' Quantidade de lote insuficiente SNGPC : ' + cast(coalesce(@SALDO_SNGPC, 0) AS VARCHAR(60))
          SET @VAL_INSERT = 0;
        END;
        IF @DT_EMISS_NF < @DATA_LIMITE
		BEGIN
		  SET @DS_ERRO = @DS_ERRO + 'Data de emissao da nota esta em um  periodo ja enviado para anvisa'
		  SET @VAL_INSERT = 0;		
		END;
		IF LEN(@DS_ERRO) > 1
			SET @VAL_INSERT = 0

		IF @VAL_INSERT = 1
		BEGIN
            PRINT 'NOTA VALIDA : FILIAL ' + CAST(@CD_FILIAL AS VARCHAR(30)) + '  NOTA ' + CAST(@NR_NF AS VARCHAR(30)) + ' PRODUTO : ' + CAST(@CD_PROD AS VARCHAR(30)) ;
			INSERT INTO #INSERT_SAIDAS_TRANSF (
				CD_EMP
				,CD_FILIAL
				,CD_PROD
				,CD_NF
				,CD_LOTE
				,CD_IT
				,DT_EMISS_NF
				,QTDE_LANCAMENTO
				
				)
			VALUES (
				@CD_EMP
				,@CD_FILIAL
				,@CD_PROD
				,@CD_VD
				,@CD_LOTE
				,@CD_IT
				,@DT_EMISS_NF
				,@QT_LOTE_TRANSF
				
				)				
		END
		ELSE
		BEGIN
			PRINT 'INSERINDO ERRO : FILIAL ' + CAST(@CD_FILIAL AS VARCHAR(30)) + '  NOTA ' + CAST(@NR_NF AS VARCHAR(30)) + ' PRODUTO : ' + CAST(@CD_PROD AS VARCHAR(30)) + ' ' + @DS_ERRO;

			INSERT INTO #TRANSF_ERROS (
				CD_EMP
				,CD_FILIAL
				,CD_NF
				,CD_IT
				,CD_LOTE
				,CD_LOTE_GESTAO
				)
			VALUES (
				@CD_EMP
				,@CD_FILIAL
				,@CD_NF
				,@CD_IT
				,@CD_LOTE
				,@CD_LOTE_GESTAO
				);

			INSERT INTO EST_SNGPC_PEND_SAIDA_TRANSF_AUDIT(
				CD_EMP
				,CD_FILIAL
				,CD_PROD
				,NR_LOTE
				,CD_IT
				,CD_NF
				,DT_CAD
				,DS_ERRO
				)
			VALUES (
				@CD_EMP
				,@CD_FILIAL
				,@CD_PROD
				,@NR_LOTE
				,@CD_IT
				,@CD_NF
				,GETDATE()
				,@DS_ERRO
				)
		END

		SET @OLD_FILIAL = @CD_FILIAL;

		FETCH NEXT
		FROM PENDENCIAS_SAIDAS_TRANSF
		INTO 
         @CD_FILIAL
		,@CD_NF
		,@DT_EMISS_NF
		,@NR_NF		
		,@CD_IT
        ,@CD_PROD
		,@QTDE_PROD		
		,@NR_LOTE
		,@SALDO_SNGPC
        ,@QT_LOTE_TRANSF		
		,@CD_LOTE
		,@CD_LOTE_GESTAO
	END;

	CLOSE PENDENCIAS_SAIDAS_TRANSF;
	DEALLOCATE PENDENCIAS_SAIDAS_TRANSF;

	DECLARE PERSITIR_TRANSF CURSOR FAST_FORWARD
	FOR
	SELECT 
		*
	FROM 
		#INSERT_SAIDAS_TRANSF
	WHERE 
		NOT EXISTS (
			SELECT 
				CD_NF
			FROM 
				#TRANSF_ERROS
			WHERE 
				#TRANSF_ERROS.CD_EMP = #INSERT_SAIDAS_TRANSF.CD_EMP
				AND #TRANSF_ERROS.CD_FILIAL = #INSERT_SAIDAS_TRANSF.CD_FILIAL
				AND #TRANSF_ERROS.CD_NF = #INSERT_SAIDAS_TRANSF.CD_NF
			)
    PRINT 'ABRINDO INSERÇÃO DE TRANSFERENCIAS'
	OPEN PERSITIR_TRANSF;

	FETCH NEXT
	FROM PERSITIR_TRANSF
	INTO @CD_EMP
		,@CD_FILIAL
		,@CD_PROD
		,@CD_NF
		,@CD_LOTE
		,@CD_IT
		,@DT_EMISS_NF
		,@QTDE_LANCAMENTO
		
	WHILE @@FETCH_STATUS = 0
	BEGIN    
		BEGIN TRY
		  PRINT 'INSERINDO NOTA TRANSFERENCIA  FILIAL: ' + CAST(@CD_FILIAL AS VARCHAR(30)) + '  NOTA ' + CAST(@NR_NF AS VARCHAR(30)) + ' PRODUTO : ' + CAST(@CD_PROD AS VARCHAR(30)) ;
		  EXEC P_EST_SNGPC_SAIDA_TRANSF_INCLUIR
		    0  --PASAR ZERADO CODIGO DE MOVIMENTACAO
            ,@CD_EMP
	     	,@CD_FILIAL
	     	,@CD_LOTE
	     	,@DT_EMISS_NF
		    ,@QTDE_LANCAMENTO
		     ,1   --USUARIO DO GESTAO
		     ,@CD_NF
             ,@CD_PROD
		     ,@CD_IT			
		     ,'AUTO_1.3';

	     	
			--REMOVER PENDENCIA
			PRINT 'REMOVENDO PENDENCIA NOTA TRANSFERENCIA  FILIAL: ' + CAST(@CD_FILIAL AS VARCHAR(30)) + '  NOTA ' + CAST(@NR_NF AS VARCHAR(30)) + ' PRODUTO : ' + CAST(@CD_PROD AS VARCHAR(30)) ;
			DELETE
            FROM 
	           est_nf_sai_it_est_sngpc_pendente
             WHERE
	           CD_EMP         = @CD_EMP
	           AND  CD_FILIAL  =@CD_FILIAL
	           AND  CD_NF      = @CD_NF
			   AND  CD_IT      = @CD_IT

		END TRY
		BEGIN CATCH 
          SELECT 
              @ErrorMessage = ERROR_MESSAGE()         		 
		  SET  @DS_ERRO ='ERRO P_EST_SNGPC_SAIDA_TRANSF_INCLUIR ' + COALESCE( @ErrorMessage ,'ERRO DESCONHECIDO') ;
		  PRINT 'ERRO NA PROCEDURE DE INSERCAO DE TRANSFERENCIAS : '+@ErrorMessage;		  
		  INSERT INTO  EST_SNGPC_PEND_SAIDA_TRANSF_AUDIT (
				CD_EMP
				,CD_FILIAL
				,CD_PROD
				,NR_LOTE
				,CD_IT
				,CD_NF
				,DT_CAD
				,DS_ERRO
				)
			VALUES (
				@CD_EMP
				,@CD_FILIAL
				,@CD_PROD
				,@NR_LOTE
				,@CD_IT
				,@CD_NF
				,GETDATE()
				,@DS_ERRO
				)
		END CATCH  

		FETCH NEXT
		FROM PERSITIR_TRANSF
		INTO @CD_EMP
			,@CD_FILIAL
			,@CD_PROD
			,@CD_NF
			,@CD_LOTE
			,@CD_IT
			,@DT_EMISS_NF
			,@QTDE_PROD
			
	END;
	CLOSE PERSITIR_TRANSF;
	DEALLOCATE PERSITIR_TRANSF;   
    PRINT 'FINALIZADO PROCESSAMENTO';		    
END